/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_data;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.mainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;

public class deriveParamDialog
implements ActionListener,
WindowListener,
ListSelectionListener {
    private final JDialog theDialog = new JDialog();
    private final parameterObject paramObj = new parameterObject();
    private final JSplitPane fileListHolder;
    private List<FCS_data> theFiles;
    private FACS_document theDocument;
    private final JList fileList;
    private static final String CLOSE = "CLOSE";
    private final JButton CLOSE_Button = new JButton("Close Dialog");
    private static final String ADD = "ADD";
    private final JButton ADD_Button = new JButton("Add Parameter");
    private static final String DEL = "DEL";
    private final JButton DEL_Button = new JButton("Delete Parameter");
    private final JCheckBox applyToAll = new JCheckBox("Apply to all FCS files");
    private ArrayList<TableModelListener> listeners = new ArrayList();

    public deriveParamDialog(mainFrame paramFrame) {
        this.theDialog.setModal(true);
        this.theDialog.setTitle("Derive Parameters");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.ADD_Button);
        this.ADD_Button.setActionCommand(ADD);
        this.ADD_Button.addActionListener(this);
        buttonPanel.add(this.DEL_Button);
        this.DEL_Button.setActionCommand(DEL);
        this.DEL_Button.addActionListener(this);
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.setActionCommand(CLOSE);
        this.CLOSE_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        JPanel listH = new JPanel(new BorderLayout());
        this.fileList = new JList();
        this.fileList.setSelectionMode(0);
        this.fileList.addListSelectionListener(this);
        JScrollPane fileScroller = new JScrollPane(this.fileList);
        listH.add((Component)fileScroller, "Center");
        listH.add((Component)this.applyToAll, "North");
        this.fileListHolder = new JSplitPane(1);
        this.fileListHolder.setDividerSize(3);
        this.fileListHolder.setLeftComponent(listH);
        this.fileListHolder.setRightComponent(this.paramObj.getPanel());
        this.theDialog.add((Component)this.fileListHolder, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.fileListHolder.setDividerLocation(220);
        this.theDialog.setSize(800, 500);
    }

    public boolean showDialog(FACS_document paramDoc) {
        this.theFiles = paramDoc.getDatafiles();
        this.theDocument = paramDoc;
        if (this.theFiles.size() > 0) {
            this.paramObj.setFile(this.theFiles.get(0));
        }
        String[] names = new String[this.theFiles.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.theFiles.get(i).getDataFileName();
        }
        this.fileList.setListData(names);
        if (names.length > 0) {
            this.fileList.setSelectedIndex(0);
        }
        this.theDialog.setTitle("Derive parameters for FACS datafiles in: " + paramDoc.getName());
        this.theDialog.validate();
        this.theDialog.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLOSE)) {
            this.theDialog.setVisible(false);
            this.theFiles = null;
            this.theDocument = null;
            this.theDialog.dispose();
            return;
        }
        if (e.getActionCommand().equals(ADD)) {
            int op;
            int param2;
            boolean badEntry = false;
            int param1 = this.paramObj.param1.getSelectedIndex();
            if (param1 == -1) {
                badEntry = true;
            }
            if ((param2 = this.paramObj.param2.getSelectedIndex()) == -1) {
                badEntry = true;
            }
            if (this.paramObj.manualValue.isEnabled()) {
                param2 = -1;
            }
            if ((op = this.paramObj.operation.getSelectedIndex()) == -1) {
                badEntry = true;
            }
            long range = 0L;
            double zero = 0.0;
            double adjust = 1.0;
            double manual = 1.0;
            try {
                range = Integer.valueOf(this.paramObj.range.getText()).intValue();
                zero = Double.valueOf(this.paramObj.zero.getText());
                adjust = Double.valueOf(this.paramObj.adjust.getText());
                if (param2 == -1) {
                    manual = Double.valueOf(this.paramObj.manualValue.getText());
                }
            }
            catch (NumberFormatException n) {
                badEntry = true;
            }
            if (range < 0L || zero < 0.0 || adjust < 0.0) {
                badEntry = true;
            }
            if (badEntry) {
                JOptionPane.showMessageDialog(null, "Bad Entry - please check the entered values.", "Bad data entry", 0);
                return;
            }
            String desc = this.paramObj.description.getText();
            int sel = this.fileList.getSelectedIndex();
            if (sel == -1) {
                sel = 0;
            }
            FCS_data selF = this.theFiles.get(sel);
            if (this.applyToAll.isSelected()) {
                for (FCS_data currF : this.theFiles) {
                    if (param1 < currF.getTotalParameterCount() && param2 < currF.getTotalParameterCount()) {
                        if (desc.isEmpty()) {
                            desc = param2 != -1 ? currF.getParameterDesc(param1) + this.paramObj.operation.getSelectedItem().toString() + currF.getParameterDesc(param2) : currF.getParameterDesc(param1) + this.paramObj.operation.getSelectedItem().toString() + manual;
                        }
                        currF.deriveParameter(param1, param2, manual, op, range, adjust, zero, desc);
                        continue;
                    }
                    badEntry = true;
                }
                this.theDocument.refreshView(true);
            } else if (param1 < selF.getTotalParameterCount() && param2 < selF.getTotalParameterCount()) {
                if (desc.isEmpty()) {
                    desc = param2 != -1 ? selF.getParameterDesc(param1) + this.paramObj.operation.getSelectedItem().toString() + selF.getParameterDesc(param2) : selF.getParameterDesc(param1) + this.paramObj.operation.getSelectedItem().toString() + manual;
                }
                selF.deriveParameter(param1, param2, manual, op, range, adjust, zero, desc);
                this.theDocument.refreshView(selF);
            } else {
                badEntry = true;
            }
            if (badEntry) {
                JOptionPane.showMessageDialog(null, "Parameter was not applied to all selected FCS files. Please check that the used parameters exist in all selected files.", "Bad data entry", 0);
            }
            this.paramObj.setFile(selF);
            return;
        }
        if (e.getActionCommand().equals(DEL)) {
            int toDelete = this.paramObj.derivedParamsList.getSelectedIndex();
            if (toDelete == -1) {
                return;
            }
            int sel = this.fileList.getSelectedIndex();
            if (sel == -1) {
                sel = 0;
            }
            FCS_data selF = this.theFiles.get(sel);
            if (this.applyToAll.isSelected()) {
                for (FCS_data currF : this.theFiles) {
                    currF.removeDerivedParameter(toDelete);
                }
                this.theDocument.refreshView(true);
            } else {
                selF.removeDerivedParameter(toDelete);
                this.theDocument.refreshView(selF);
            }
            this.paramObj.setFile(selF);
            return;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.paramObj.simpleScroller.getViewport().setViewPosition(new Point(0, 0));
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theDialog.setVisible(false);
        this.theFiles = null;
        this.theDocument = null;
        this.theDialog.dispose();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selected = this.fileList.getSelectedIndex();
        if (selected < 0) {
            selected = 0;
        }
        FCS_data currentFile = this.theFiles.get(selected);
        this.paramObj.setFile(currentFile);
    }

    private static class scrollablePanel
    extends JPanel
    implements Scrollable {
        private JPanel panel;
        private Component left = Box.createHorizontalStrut(5);
        private Component right = Box.createHorizontalStrut(5);
        private int w;

        public scrollablePanel(JPanel thePanel, int maxWidth) {
            this.panel = thePanel;
            this.w = maxWidth;
            this.setLayout(new BorderLayout());
            this.add(this.left, "East");
            this.add(this.right, "West");
            this.add((Component)this.panel, "Center");
            this.add(Box.createVerticalStrut(5), "North");
            this.add(Box.createVerticalStrut(5), "South");
        }

        @Override
        public void setSize(Dimension d) {
            int wid = (int)d.getWidth() - 1;
            if (wid > this.w) {
                int b = wid - this.w;
                if ((b /= 2) < 5) {
                    b = 5;
                }
                Dimension f = new Dimension(b, 0);
                this.left.setPreferredSize(f);
                this.right.setPreferredSize(f);
            }
            super.setSize(d);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }

    private class parameterObject
    implements ActionListener {
        public JPanel thePanel = new JPanel();
        private JSplitPane holder = new JSplitPane(0);
        private JTabbedPane tabs = new JTabbedPane();
        private JList derivedParamsList = new JList();
        private FCS_data theFile;
        boolean isAdjusting = false;
        private JPanel simplePanel = new JPanel();
        private JTextField description = new JTextField();
        private JTextField range = new JTextField();
        private JTextField adjust = new JTextField();
        private JScrollPane simpleScroller;
        private JComboBox param1 = new JComboBox();
        private JComboBox param2 = new JComboBox();
        private JComboBox operation = new JComboBox();
        private JTextField zero = new JTextField();
        private JTextField manualValue = new JTextField();
        private String manual = "Manual Value:";
        private JTextArea divInfo = new JTextArea();
        private JPanel PCA_Panel = new JPanel();
        private JTextField descriptionPCA = new JTextField();
        private JTextField rangePCA = new JTextField();
        private JTextField adjustPCA = new JTextField();
        private JScrollPane PCA_scroller;
        private JScrollPane PCA_factors;
        private JTable PCA_table;
        private JTextArea divInfoPCA = new JTextArea();

        public parameterObject() {
            this.holder.setDividerSize(3);
            this.holder.setDividerLocation(100);
            JScrollPane listScroller = new JScrollPane(this.derivedParamsList);
            this.holder.setTopComponent(listScroller);
            this.operation.setEditable(false);
            this.operation.addItem(" + ");
            this.operation.addItem(" - ");
            this.operation.addItem(" x ");
            this.operation.addItem(" / ");
            this.param1.setEditable(false);
            this.param2.setEditable(false);
            GridBagLayout g = new GridBagLayout();
            this.simplePanel.setLayout(g);
            GridBagConstraints gb = new GridBagConstraints();
            gb.weightx = 0.5;
            gb.gridwidth = 1;
            gb.gridy = 0;
            gb.gridx = 0;
            this.simplePanel.add(Box.createGlue(), gb);
            gb.gridx = 1;
            this.simplePanel.add(Box.createGlue(), gb);
            gb.gridx = 2;
            this.simplePanel.add(Box.createGlue(), gb);
            gb.gridx = 3;
            this.simplePanel.add(Box.createGlue(), gb);
            gb.fill = 1;
            gb.gridwidth = 4;
            gb.gridx = 0;
            JTextArea L0 = new JTextArea("Enter a name/description for this derived parameter:");
            L0.setEditable(false);
            L0.setWrapStyleWord(true);
            L0.setLineWrap(true);
            L0.setOpaque(false);
            gb.insets = new Insets(5, 5, 0, 5);
            ++gb.gridy;
            this.simplePanel.add((Component)L0, gb);
            gb.insets = new Insets(0, 5, 5, 5);
            ++gb.gridy;
            gb.gridx = 1;
            gb.gridwidth = 2;
            this.simplePanel.add((Component)this.description, gb);
            gb.gridx = 0;
            gb.gridwidth = 4;
            JTextArea L1 = new JTextArea("Please select the parameter and what to do with them:");
            L1.setEditable(false);
            L1.setWrapStyleWord(true);
            L1.setLineWrap(true);
            L1.setOpaque(false);
            gb.insets = new Insets(5, 5, 0, 5);
            ++gb.gridy;
            this.simplePanel.add((Component)L1, gb);
            JPanel paramH = new JPanel();
            paramH.add(this.param1);
            paramH.add(this.operation);
            paramH.add(this.param2);
            this.manualValue.setText("1.0");
            paramH.add(this.manualValue);
            gb.insets = new Insets(0, 5, 5, 5);
            ++gb.gridy;
            this.simplePanel.add((Component)paramH, gb);
            JTextArea L3 = new JTextArea("Please indicate a value by which the result is divided. This is useful to adjust the calculated value to the general range of the parameters. For example, when adding two parameters dividing the result by 2 will bring the derived parameter to the same range as the source parameters.");
            L3.setEditable(false);
            L3.setWrapStyleWord(true);
            L3.setLineWrap(true);
            L3.setOpaque(false);
            ++gb.gridy;
            gb.insets = new Insets(5, 5, 0, 5);
            this.simplePanel.add((Component)L3, gb);
            ++gb.gridy;
            gb.insets = new Insets(0, 5, 5, 5);
            gb.gridx = 1;
            gb.gridwidth = 1;
            this.simplePanel.add((Component)this.adjust, gb);
            gb.gridx = 0;
            gb.gridwidth = 4;
            JTextArea L2 = new JTextArea("Please indicate the maximum value. Calculated values are cut-off to this maximum. Usually the maximum value would match the range of the used parameters. Whole numbers only.");
            L2.setEditable(false);
            L2.setWrapStyleWord(true);
            L2.setLineWrap(true);
            L2.setOpaque(false);
            ++gb.gridy;
            gb.insets = new Insets(5, 5, 0, 5);
            this.simplePanel.add((Component)L2, gb);
            ++gb.gridy;
            gb.insets = new Insets(0, 5, 5, 5);
            gb.gridx = 1;
            gb.gridwidth = 1;
            this.simplePanel.add((Component)this.range, gb);
            gb.gridx = 0;
            gb.gridwidth = 4;
            this.divInfo.setText("Please indicate a value that is used for division by zero. This is necessary as FCS parameter values may be 0, but a dividion by 0 can't be calculated. Whole numbers only.");
            this.divInfo.setEditable(false);
            this.divInfo.setWrapStyleWord(true);
            this.divInfo.setLineWrap(true);
            this.divInfo.setOpaque(false);
            ++gb.gridy;
            gb.insets = new Insets(5, 5, 0, 5);
            this.simplePanel.add((Component)this.divInfo, gb);
            gb.insets = new Insets(0, 5, 5, 5);
            ++gb.gridy;
            gb.gridx = 1;
            gb.gridwidth = 1;
            this.simplePanel.add((Component)this.zero, gb);
            this.param2.addActionListener(this);
            this.operation.addActionListener(this);
            this.manualValue.setEnabled(false);
            this.divInfo.setEnabled(false);
            this.zero.setEnabled(false);
            this.simplePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            scrollablePanel hold = new scrollablePanel(this.simplePanel, 500);
            this.simpleScroller = new JScrollPane(hold);
            this.simpleScroller.validate();
            this.PCA_scroller = new JScrollPane(this.PCA_Panel);
            this.tabs.add("simple derived parameter", this.simpleScroller);
            this.holder.setBottomComponent(this.tabs);
            this.thePanel.setLayout(new BorderLayout());
            this.thePanel.add((Component)this.holder, "Center");
        }

        public JPanel getPanel() {
            return this.thePanel;
        }

        public void setFile(FCS_data newFile) {
            String[] p2;
            String[] p1;
            this.isAdjusting = true;
            this.theFile = newFile;
            String[] derList = this.theFile.getDerivedParameterDefinitions();
            this.derivedParamsList.setListData(derList);
            this.param1.removeAllItems();
            for (String curr : p1 = this.theFile.getParameterLabels()) {
                this.param1.addItem(curr);
            }
            this.param2.removeAllItems();
            for (String curr : p2 = this.theFile.getParameterLabels()) {
                this.param2.addItem(curr);
            }
            this.param2.addItem(this.manual);
            this.adjust.setText("2.0");
            this.range.setText(String.valueOf(this.theFile.getRange(this.theFile.getRawParameterCount() - 1)));
            this.zero.setText(this.range.getText());
            this.isAdjusting = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.param2) {
                if (this.param2.getSelectedItem() == this.manual) {
                    this.manualValue.setEnabled(true);
                } else {
                    this.manualValue.setEnabled(false);
                }
            } else if (e.getSource() == this.operation) {
                if (this.operation.getSelectedIndex() == 3) {
                    this.zero.setEnabled(true);
                    this.divInfo.setEnabled(true);
                } else {
                    this.zero.setEnabled(false);
                    this.divInfo.setEnabled(false);
                }
            }
        }
    }
}

