/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlTextRendererBase;

public class HtmlFormatRenderer
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlFormatRenderer.class.getName());
    private static final Object[] EMPTY_ARGS = new Object[0];

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        String text = this.getOutputFormatText(facesContext, component);
        boolean isEscape = component instanceof HtmlOutputFormat ? ((HtmlOutputFormat)component).isEscape() : RendererUtils.getBooleanAttribute(component, "escape", true);
        HtmlTextRendererBase.renderOutputText(facesContext, component, text, isEscape);
    }

    private String getOutputFormatText(FacesContext facesContext, UIComponent htmlOutputFormat) {
        Object[] args;
        String pattern = RendererUtils.getStringValue(facesContext, htmlOutputFormat);
        if (htmlOutputFormat.getChildCount() == 0) {
            args = EMPTY_ARGS;
        } else {
            ArrayList<Object> argsList = new ArrayList<Object>();
            List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, htmlOutputFormat.getChildren(), false, false, false);
            for (UIParameter param : validParams) {
                argsList.add(param.getValue());
            }
            args = argsList.toArray(new Object[argsList.size()]);
        }
        MessageFormat format = new MessageFormat(pattern, facesContext.getViewRoot().getLocale());
        try {
            return format.format(args);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error formatting message of component " + htmlOutputFormat.getClientId(facesContext));
            return "";
        }
    }
}

