/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.remote.InboundClient;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnsentRequestHandlerConnector
implements RequestHandlerConnector {
    private static final AtomicIntegerFieldUpdater<UnsentRequestHandlerConnector> sentUpdater = AtomicIntegerFieldUpdater.newUpdater(UnsentRequestHandlerConnector.class, "sent");
    private final int clientId;
    private final RemoteConnectionHandler remoteConnectionHandler;
    private volatile int sent = 0;

    UnsentRequestHandlerConnector(int clientId, RemoteConnectionHandler remoteConnectionHandler) {
        this.clientId = clientId;
        this.remoteConnectionHandler = remoteConnectionHandler;
    }

    @Override
    public Cancellable createRequestHandler(Result<RemoteRequestHandler> result) throws SecurityException {
        throw new SecurityException("Request handler not sent");
    }

    void send() {
        this.sent = 1;
    }

    boolean isSent() {
        return this.sent != 0;
    }

    int getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (sentUpdater.compareAndSet(this, 0, 1)) {
            IntKeyMap<InboundClient> inboundClients;
            IntKeyMap<InboundClient> intKeyMap = inboundClients = this.remoteConnectionHandler.getInboundClients();
            synchronized (intKeyMap) {
                inboundClients.remove(this.clientId);
            }
        }
        super.finalize();
    }
}

