/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.profileservice.plugins.management.util.AbstractManagedComponentRuntimeDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRuntimeComponentDispatcher
extends AbstractManagedComponentRuntimeDispatcher {
    private final MBeanServer mbeanServer;

    public MBeanRuntimeComponentDispatcher(MBeanServer mbeanServer) {
        if (mbeanServer == null) {
            throw new IllegalStateException("null mbean server");
        }
        this.mbeanServer = mbeanServer;
    }

    protected Object get(Object name, String getter) throws Throwable {
        return this.mbeanServer.getAttribute(new ObjectName(name.toString()), getter);
    }

    protected void set(Object name, String setter, Object value) throws Throwable {
        this.mbeanServer.setAttribute(new ObjectName(name.toString()), new Attribute(setter, value));
    }

    protected Object invoke(Object name, String methodName, Object[] parameters, String[] signature) throws Throwable {
        return this.mbeanServer.invoke(new ObjectName(name.toString()), methodName, parameters, signature);
    }

    public String getState(Object name) {
        try {
            if (this.mbeanServer.isRegistered(new ObjectName(name.toString()))) {
                return ControllerState.INSTALLED.getStateString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ControllerState.NOT_INSTALLED.getStateString();
    }

    public <T extends Enum<?>> T mapControllerState(Object name, ContextStateMapper<T> mapper) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("null mapper");
        }
        ControllerState current = ControllerState.NOT_INSTALLED;
        try {
            if (this.mbeanServer.isRegistered(new ObjectName(name.toString()))) {
                current = ControllerState.INSTALLED;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return (T)mapper.map(current.getStateString(), ControllerState.INSTALLED.getStateString());
    }
}

