/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class URLConnectionHeaderWrapper
implements MultivaluedMap<String, String> {
    private CaseInsensitiveMap<String> cachedHeaders = new CaseInsensitiveMap();
    private URLConnection connection;
    private ResteasyProviderFactory factory;

    public URLConnectionHeaderWrapper(URLConnection connection, ResteasyProviderFactory factory) {
        this.connection = connection;
        this.factory = factory;
    }

    public void sync() {
        for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
            for (String string : entry.getValue()) {
                this.cachedHeaders.add(entry.getKey(), string);
            }
        }
    }

    public void putSingle(String key, String value) {
        this.cachedHeaders.putSingle(key, value);
        this.addResponseHeader(key, value);
    }

    public void add(String key, String value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate<?> delegate = this.factory.createHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.connection.addRequestProperty(key.toLowerCase(), delegate.toString(value));
        } else {
            this.connection.addRequestProperty(key.toLowerCase(), value.toString());
        }
    }

    public String getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    public int size() {
        return this.cachedHeaders.size();
    }

    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    public List<String> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    public List<String> put(String s, List<String> objs) {
        for (String obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    public List<String> remove(Object o) {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : map.entrySet()) {
            for (String obj : entry.getValue()) {
                this.add(entry.getKey(), obj);
            }
        }
    }

    public void clear() {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    public Collection<List<String>> values() {
        return this.cachedHeaders.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }
}

