/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.jtype;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.hibernate.validator.jtype.ClassSerializer;
import org.hibernate.validator.jtype.ClassSerializers;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.jtype.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTypeVariable<D extends GenericDeclaration>
implements TypeVariable<D> {
    private static final Type[] DEFAULT_BOUNDS = new Type[]{Object.class};
    private final D declaration;
    private final String name;
    private final Type[] bounds;

    public DefaultTypeVariable(D declaration, String name, Type[] bounds) {
        if (bounds == null || bounds.length == 0) {
            bounds = DEFAULT_BOUNDS;
        }
        Utils.checkTrue(DefaultTypeVariable.isValidFirstBound(bounds[0]), "First bound must be either a class type, an interface type or a type variable", bounds[0]);
        for (int i = 1; i < bounds.length; ++i) {
            Utils.checkTrue(DefaultTypeVariable.isValidSecondaryBound(bounds[i]), "Secondary bounds must be an interface type: ", bounds[i]);
        }
        this.declaration = (GenericDeclaration)Utils.checkNotNull(declaration, "declaration");
        this.name = Utils.checkNotNull(name, "name");
        this.bounds = (Type[])bounds.clone();
    }

    @Override
    public D getGenericDeclaration() {
        return this.declaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type[] getBounds() {
        return (Type[])this.bounds.clone();
    }

    public int hashCode() {
        int hashCode = this.declaration.hashCode();
        hashCode = hashCode * 37 + this.name.hashCode();
        hashCode = hashCode * 37 + Arrays.hashCode(this.bounds);
        return hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypeVariable)) {
            return false;
        }
        TypeVariable typeVariable = (TypeVariable)object;
        return this.declaration.equals(typeVariable.getGenericDeclaration()) && this.name.equals(typeVariable.getName()) && Arrays.equals(this.bounds, typeVariable.getBounds());
    }

    public String toString() {
        return DefaultTypeVariable.toString(this);
    }

    public static String toString(TypeVariable<?> type) {
        return DefaultTypeVariable.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(TypeVariable<?> type, ClassSerializer serializer) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.getName());
        if (!Arrays.equals(DEFAULT_BOUNDS, type.getBounds())) {
            builder.append(" extends ");
            TypeUtils.appendBounds(builder, type.getBounds(), serializer);
        }
        return builder.toString();
    }

    private static boolean isValidFirstBound(Type bound) {
        return bound instanceof Class && !((Class)bound).isArray() || bound instanceof ParameterizedType || bound instanceof TypeVariable;
    }

    private static boolean isValidSecondaryBound(Type bound) {
        if (bound instanceof Class) {
            return ((Class)bound).isInterface();
        }
        if (bound instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)bound).getRawType();
            return rawType instanceof Class && ((Class)rawType).isInterface();
        }
        return false;
    }
}

