/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseURL {
    static final String S_DOT = ".";
    public static final String S_MEM = "mem:";
    public static final String S_FILE = "file:";
    public static final String S_RES = "res:";
    public static final String S_ALIAS = "alias:";
    public static final String S_HSQL = "hsql://";
    public static final String S_HSQLS = "hsqls://";
    public static final String S_HTTP = "http://";
    public static final String S_HTTPS = "https://";
    public static final String S_URL_PREFIX = "jdbc:hsqldb:";

    public static boolean isFileBasedDatabaseType(String string) {
        return string == S_FILE || string == S_RES;
    }

    public static boolean isInProcessDatabaseType(String string) {
        return string == S_FILE || string == S_RES || string == S_MEM;
    }

    public static HsqlProperties parseURL(String string, boolean bl) {
        String string2;
        String string3 = string.toLowerCase(Locale.ENGLISH);
        HsqlProperties hsqlProperties = new HsqlProperties();
        HsqlProperties hsqlProperties2 = null;
        String string4 = null;
        int n = 0;
        if (bl) {
            if (string3.startsWith(S_URL_PREFIX)) {
                n = S_URL_PREFIX.length();
            } else {
                return hsqlProperties;
            }
        }
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        boolean bl2 = false;
        hsqlProperties.setProperty("url", string);
        int n3 = string.indexOf(59, n);
        if (n3 < 0) {
            n3 = string.length();
        } else {
            string4 = string3.substring(n3 + 1, string3.length());
            hsqlProperties2 = HsqlProperties.delimitedArgPairsToProps(string4, "=", ";", null);
            hsqlProperties.addProperties(hsqlProperties2);
        }
        if (n3 == n + 1 && string3.startsWith(S_DOT, n)) {
            string5 = S_DOT;
        } else if (string3.startsWith(S_MEM, n)) {
            string5 = S_MEM;
        } else if (string3.startsWith(S_FILE, n)) {
            string5 = S_FILE;
        } else if (string3.startsWith(S_RES, n)) {
            string5 = S_RES;
        } else if (string3.startsWith(S_ALIAS, n)) {
            string5 = S_ALIAS;
        } else if (string3.startsWith(S_HSQL, n)) {
            string5 = S_HSQL;
            n2 = 9001;
            bl2 = true;
        } else if (string3.startsWith(S_HSQLS, n)) {
            string5 = S_HSQLS;
            n2 = 554;
            bl2 = true;
        } else if (string3.startsWith(S_HTTP, n)) {
            string5 = S_HTTP;
            n2 = 80;
            bl2 = true;
        } else if (string3.startsWith(S_HTTPS, n)) {
            string5 = S_HTTPS;
            n2 = 443;
            bl2 = true;
        }
        if (string5 == null) {
            string5 = S_FILE;
        } else if (string5 == S_DOT) {
            string5 = S_MEM;
        } else {
            n += string5.length();
        }
        hsqlProperties.setProperty("connection_type", string5);
        if (bl2) {
            String string7;
            String string8;
            int n4;
            int n5;
            int n6 = string.indexOf(47, n);
            if (n6 < n || n6 > n3) {
                n6 = n3;
            }
            if (string3.charAt(n) == '[') {
                n5 = string3.indexOf(93, n + 1);
                if (n5 <= n || n5 >= n6) {
                    return null;
                }
                string6 = string3.substring(n + 1, n5);
            }
            if ((n5 = string.indexOf(58, string6 == null ? n : n + 2 + string6.length())) < n || n5 > n6) {
                n5 = n6;
            } else {
                try {
                    n2 = Integer.parseInt(string.substring(n5 + 1, n6));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (string6 == null) {
                string6 = string3.substring(n, n5);
            }
            if ((n4 = string.lastIndexOf(47, n3)) < n) {
                string8 = "/";
                string2 = "";
            } else if (n4 == n6) {
                string8 = "/";
                string2 = string3.substring(n4 + 1, n3);
            } else {
                string8 = string.substring(n6, n4);
                string2 = string3.substring(n4 + 1, n3);
            }
            hsqlProperties.setProperty("port", n2);
            hsqlProperties.setProperty("host", string6);
            hsqlProperties.setProperty("path", string8);
            if (hsqlProperties2 != null && (string7 = hsqlProperties2.getProperty("filepath")) != null && string2.length() != 0) {
                string2 = string2 + ";" + string7;
            }
        } else {
            if (string5 == S_MEM || string5 == S_RES) {
                string2 = string3.substring(n, n3).toLowerCase();
                if (string5 == S_RES && string2.indexOf(47) != 0) {
                    string2 = '/' + string2;
                }
            } else {
                string2 = string.substring(n, n3);
            }
            if (string2.length() == 0) {
                return null;
            }
        }
        hsqlProperties.setProperty("database", string2);
        return hsqlProperties;
    }
}

