/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.JvmRouteFactory;

public class SystemPropertyJvmRouteFactory
implements JvmRouteFactory {
    public static final String PROPERTY = "jboss.mod_cluster.jvmRoute";
    private final String property;
    private final JvmRouteFactory factory;

    public SystemPropertyJvmRouteFactory(JvmRouteFactory factory) {
        this(factory, PROPERTY);
    }

    public SystemPropertyJvmRouteFactory(JvmRouteFactory factory, String property) {
        this.factory = factory;
        this.property = property;
    }

    public String createJvmRoute(Engine engine) {
        final String defaultJvmRoute = this.factory.createJvmRoute(engine);
        final String property = this.property;
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property, defaultJvmRoute);
            }
        };
        return AccessController.doPrivileged(action);
    }
}

