/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.remoting3.ReplyException;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.remoting3.spi.RemoteReplyHandler;

class LocalRemoteReplyHandler
implements RemoteReplyHandler {
    private final LocalReplyHandler replyHandler;
    private final ObjectCloner replyCloner;

    public LocalRemoteReplyHandler(LocalReplyHandler replyHandler, ObjectCloner replyCloner) {
        this.replyHandler = replyHandler;
        this.replyCloner = replyCloner;
    }

    public void handleReply(Object reply) throws IOException {
        try {
            this.replyHandler.handleReply(this.replyCloner.clone(reply));
        }
        catch (ClassNotFoundException e) {
            ReplyException re = new ReplyException("Cannot clone reply", e);
            this.replyHandler.handleException(re);
            throw re;
        }
    }

    public void handleException(IOException exception) throws IOException {
        try {
            this.replyHandler.handleException((IOException)this.replyCloner.clone((Object)exception));
        }
        catch (ClassNotFoundException e) {
            ReplyException re = new ReplyException("Cannot clone reply", e);
            this.replyHandler.handleException(re);
            throw re;
        }
    }

    public void handleCancellation() throws IOException {
        this.replyHandler.handleCancellation();
    }

    public ClassLoader getClassLoader() {
        return this.replyHandler.getClassLoader();
    }
}

