/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.domain;

import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.profileservice.domain.ManagementDomainMetaData;
import org.jboss.profileservice.domain.ServerMetaData;
import org.jboss.profileservice.domain.resources.JdbcResource;
import org.jboss.profileservice.domain.resources.JmsResource;
import org.jboss.profileservice.domain.resources.QueueResource;
import org.jboss.profileservice.domain.resources.TopicResource;
import org.jboss.profileservice.domain.spi.DomainMetaData;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.domain.threadpool.ThreadsMetaData;
import org.jboss.xb.annotations.JBossXmlNsPrefix;
import org.jboss.xb.annotations.JBossXmlSchema;

@JBossXmlSchema(namespace="urn:jboss:profileservice:domain:1.0", elementFormDefault=XmlNsForm.QUALIFIED, normalizeSpace=true, replacePropertyRefs=true, xmlns={@XmlNs(namespaceURI="urn:jboss:profileservice:server:1.0", prefix="server"), @XmlNs(namespaceURI="urn:jboss:profileservice:jdbc-resources:1.0", prefix="jdbc"), @XmlNs(namespaceURI="urn:jboss:profileservice:jms-resources:1.0", prefix="jms"), @XmlNs(namespaceURI="urn:jboss:profileservice:threads:1.0", prefix="tp")})
@XmlRootElement(name="domain")
@XmlType(name="domainType", propOrder={"server", "jdbcResources", "jmsResources", "threads", "fragments"})
public class AbstractDomainMetaData
implements DomainMetaData {
    private ManagementDomainMetaData domain;
    private ServerMetaData server;
    private ThreadsMetaData threadPools;
    private List<JdbcResource> jdbcResources;
    private List<JmsResource> jmsResources;
    private List<DomainMetaDataFragment> fragments;

    @XmlTransient
    public ManagementDomainMetaData getDomain() {
        return this.domain;
    }

    public void setDomain(ManagementDomainMetaData domain) {
        this.domain = domain;
    }

    @JBossXmlNsPrefix(prefix="server")
    public ServerMetaData getServer() {
        return this.server;
    }

    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    @XmlElementWrapper(name="jdbc-resources", namespace="urn:jboss:profileservice:jdbc-resources:1.0")
    @XmlElement(name="jdbc-resource")
    @JBossXmlNsPrefix(prefix="jdbc")
    public List<JdbcResource> getJdbcResources() {
        return this.jdbcResources;
    }

    public void setJdbcResources(List<JdbcResource> jdbcResources) {
        this.jdbcResources = jdbcResources;
    }

    @XmlElement(name="threads", namespace="urn:jboss:profileservice:threads:1.0")
    @JBossXmlNsPrefix(prefix="tp")
    public ThreadsMetaData getThreads() {
        return this.threadPools;
    }

    public void setThreads(ThreadsMetaData threadPools) {
        this.threadPools = threadPools;
    }

    @XmlElementWrapper(name="jms-resources", namespace="urn:jboss:profileservice:jms-resources:1.0")
    @XmlElements(value={@XmlElement(name="queue", type=QueueResource.class), @XmlElement(name="topic", type=TopicResource.class)})
    @JBossXmlNsPrefix(prefix="jms")
    public List<JmsResource> getJmsResources() {
        return this.jmsResources;
    }

    public void setJmsResources(List<JmsResource> jmsResources) {
        this.jmsResources = jmsResources;
    }

    @Override
    @XmlAnyElement
    public List<DomainMetaDataFragment> getFragments() {
        return this.fragments;
    }

    public void setFragments(List<DomainMetaDataFragment> elements) {
        this.fragments = elements;
    }

    @Override
    public void visit(DomainMetaDataFragmentVisitor visitor) {
        if (this.fragments != null && !this.fragments.isEmpty()) {
            for (DomainMetaDataFragment fragment : this.fragments) {
                visitor.visit(fragment);
            }
        }
    }
}

