/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader.thread;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import org.jboss.metadata.plugins.loader.AbstractMutableMetaDataLoader;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.thread.GetThreadName;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.Item;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.ValidTime;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
import org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalMetaDataLoader
extends AbstractMutableMetaDataLoader {
    public static final ThreadLocalMetaDataLoader INSTANCE = new ThreadLocalMetaDataLoader();
    private static final GetThreadName GET_THREAD_NAME = new GetThreadName();
    private ThreadLocal<MemoryMetaDataLoader> threadLocal = new ThreadLocal();
    private final BasicAnnotationsItem NO_ANNOTATIONS = new BasicAnnotationsItem(this, BasicAnnotationsItem.NO_ANNOTATION_ITEMS);
    private final BasicMetaDatasItem NO_META_DATA = new BasicMetaDatasItem(this, BasicMetaDatasItem.NO_META_DATA_ITEMS);

    private static final ScopeKey getThreadScopeKey() {
        String name = AccessController.doPrivileged(GET_THREAD_NAME);
        Scope scope = new Scope(CommonLevels.THREAD, name);
        return new ScopeKey(scope);
    }

    private ThreadLocalMetaDataLoader() {
        super(true);
    }

    public void clear() {
        this.threadLocal.set(null);
    }

    @Override
    public ScopeKey getScope() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return ThreadLocalMetaDataLoader.getThreadScopeKey();
        }
        return delegate.getScope();
    }

    @Override
    public <T> boolean isCachable(Item<T> item) {
        return false;
    }

    @Override
    public ValidTime getValidTime() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return super.getValidTime();
        }
        return delegate.getValidTime();
    }

    @Override
    public void invalidate() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            super.invalidate();
        } else {
            delegate.invalidate();
        }
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return this.NO_ANNOTATIONS;
        }
        return delegate.retrieveAnnotations();
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.retrieveAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T addAnnotation(T annotation) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            delegate = new MemoryMetaDataLoader(ThreadLocalMetaDataLoader.getThreadScopeKey(), false, true);
            this.threadLocal.set(delegate);
        }
        return delegate.addAnnotation(annotation);
    }

    @Override
    public <T extends Annotation> T removeAnnotation(Class<T> annotationType) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.removeAnnotation(annotationType);
    }

    @Override
    public AnnotationsItem retrieveAnnotationsAnnotatedWith(Class<? extends Annotation> meta) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return this.NO_ANNOTATIONS;
        }
        return delegate.retrieveAnnotationsAnnotatedWith(meta);
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return this.NO_META_DATA;
        }
        return delegate.retrieveMetaData();
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.retrieveMetaData(type);
    }

    @Override
    public MetaDataItem<?> retrieveMetaData(String name) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.retrieveMetaData(name);
    }

    @Override
    public <T> T addMetaData(T metaData, Class<T> type) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            delegate = new MemoryMetaDataLoader(ThreadLocalMetaDataLoader.getThreadScopeKey(), false, true);
            this.threadLocal.set(delegate);
        }
        return delegate.addMetaData(metaData, type);
    }

    @Override
    public <T> T removeMetaData(Class<T> type) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.removeMetaData(type);
    }

    @Override
    public <T> T addMetaData(String name, T metaData, Class<T> type) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            delegate = new MemoryMetaDataLoader(ThreadLocalMetaDataLoader.getThreadScopeKey(), false, true);
            this.threadLocal.set(delegate);
        }
        return delegate.addMetaData(name, metaData, type);
    }

    @Override
    public <T> T removeMetaData(String name, Class<T> type) {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        if (delegate == null) {
            return null;
        }
        return delegate.removeMetaData(name, type);
    }

    @Override
    public boolean isEmpty() {
        MemoryMetaDataLoader delegate = this.threadLocal.get();
        return delegate == null || delegate.isEmpty();
    }
}

