/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.metadata.helpers;

import java.net.URI;
import java.util.ArrayList;
import org.jboss.profileservice.profile.metadata.BasicProfileDeploymentMetaData;
import org.jboss.profileservice.profile.metadata.BasicProfileMetaData;
import org.jboss.profileservice.profile.metadata.FileRepositorySourceConfiguration;
import org.jboss.profileservice.profile.metadata.plugin.HotDeploymentProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileSourceMetaData;
import org.jboss.profileservice.profile.metadata.plugin.ScanPeriod;
import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;

public class ProfileMetaDataFactory {
    public static BasicProfileMetaData createFilteredProfileMetaData(String name, String group, String ... deploymentNames) {
        return ProfileMetaDataFactory.createFilteredProfileMetaData(name, null, group, deploymentNames);
    }

    public static BasicProfileMetaData createFilteredProfileMetaData(String name, URI root, String ... deploymentNames) {
        return ProfileMetaDataFactory.createFilteredProfileMetaData(name, root, root.toString(), deploymentNames);
    }

    protected static BasicProfileMetaData createFilteredProfileMetaData(String name, URI root, String group, String ... deploymentNames) {
        BasicProfileMetaData filtered = new BasicProfileMetaData();
        filtered.setName(name);
        filtered.setSource(ProfileMetaDataFactory.createFileRepositoryConfiguration(root, group));
        ArrayList<ProfileDeploymentMetaData> deployments = new ArrayList<ProfileDeploymentMetaData>();
        for (String deploymentName : deploymentNames) {
            deployments.add(new BasicProfileDeploymentMetaData(deploymentName));
        }
        filtered.setDeployments(deployments);
        return filtered;
    }

    protected static FileRepositorySourceConfiguration createFileRepositoryConfiguration(URI root, String group) {
        FileRepositorySourceConfiguration source = new FileRepositorySourceConfiguration();
        source.setRoot(root);
        source.setGroup(group);
        return source;
    }

    public static PropertyProfileMetaData createImmutableScanningProfile(String name, URI root) {
        PropertyProfileMetaData profile = new PropertyProfileMetaData();
        profile.setName(name);
        PropertyProfileSourceMetaData source = new PropertyProfileSourceMetaData(root.toString());
        profile.setSource(source);
        return profile;
    }

    public static HotDeploymentProfileMetaData createHotDeploymentScanningProfile(String profileName, URI root, ScanPeriod scanPeriod) {
        HotDeploymentProfileMetaData profileMetaData = new HotDeploymentProfileMetaData();
        profileMetaData.setName(profileName);
        PropertyProfileSourceMetaData source = new PropertyProfileSourceMetaData(root.toString());
        profileMetaData.setSource(source);
        profileMetaData.setScanPeriod(scanPeriod);
        return profileMetaData;
    }
}

