/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.actions;

import org.jboss.profileservice.spi.action.ActionState;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.TwoPhaseCommitProfileAction;

public abstract class AbstractTwoPhaseModificationAction<T extends ProfileModificationContext>
implements TwoPhaseCommitProfileAction<T> {
    private final T modificationContext;
    private ActionState state = ActionState.ACTIVE;
    private boolean cancelled = false;
    private boolean complete = false;

    public AbstractTwoPhaseModificationAction(T modificationContext) {
        this.modificationContext = modificationContext;
    }

    public T getContext() {
        return this.modificationContext;
    }

    public ActionState getState() {
        return this.state;
    }

    public void cancel() {
        if (this.state == ActionState.ACTIVE) {
            this.doCancel();
            this.cancelled = true;
            this.state = ActionState.CANCELLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(ProfileModificationResponse response) {
        if (this.state == ActionState.ACTIVE) {
            try {
                this.doComplete(response);
                this.state = ActionState.COMPLETED;
            }
            catch (Exception e) {
                this.state = ActionState.ROLLBACK;
                response.setFailure((Throwable)e);
            }
            finally {
                this.complete = true;
            }
        }
    }

    public boolean prepare(ProfileModificationResponse response) {
        boolean result = false;
        switch (this.state) {
            case ACTIVE: {
                this.complete(response);
                if (this.state != ActionState.COMPLETED) break;
            }
            case COMPLETED: {
                result = this.doPrepare(response);
                if (result) {
                    this.state = ActionState.PREPARED;
                    result = true;
                    break;
                }
                this.state = ActionState.ROLLBACK;
                break;
            }
        }
        return result;
    }

    public void commit(ProfileModificationResponse response) {
        switch (this.state) {
            case PREPARED: {
                this.doCommit(response);
                this.state = ActionState.COMMITTED;
                break;
            }
        }
    }

    public void rollback(ProfileModificationResponse response) {
        switch (this.state) {
            case COMMITTED: 
            case ROLLEDBACK: {
                return;
            }
            case ACTIVE: {
                this.doRollbackFromActive();
                break;
            }
            case CANCELLED: {
                this.doRollbackFromCancelled();
                break;
            }
            case ROLLBACK: {
                this.doRollbackFromRollbackOnly();
                break;
            }
            case COMPLETED: {
                this.doRollbackFromComplete();
                break;
            }
            case PREPARED: {
                this.doRollbackFromPrepared();
            }
        }
        this.state = ActionState.ROLLEDBACK;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected abstract void doCancel();

    protected abstract void doComplete(ProfileModificationResponse var1) throws Exception;

    protected abstract boolean doPrepare(ProfileModificationResponse var1);

    protected abstract void doCommit(ProfileModificationResponse var1);

    protected abstract void doRollbackFromActive();

    protected abstract void doRollbackFromCancelled();

    protected abstract void doRollbackFromRollbackOnly();

    protected abstract void doRollbackFromComplete();

    protected abstract void doRollbackFromPrepared();

    protected void setRollbackOnly() {
        if (this.state != ActionState.PREPARED && this.state != ActionState.COMMITTED && this.state != ActionState.ROLLEDBACK) {
            this.state = ActionState.ROLLBACK;
        }
    }
}

