/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationValidatingVisitor;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.CacheWrapper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.ReflectionCache;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
implements EmbeddedCacheManager,
CacheManager {
    public static final String OBJECT_NAME = "CacheManager";
    private static final Log log = LogFactory.getLog(DefaultCacheManager.class);
    protected final GlobalConfiguration globalConfiguration;
    protected final Configuration defaultConfiguration;
    private final ConcurrentMap<String, CacheWrapper> caches = new ConcurrentHashMap<String, CacheWrapper>();
    private final ConcurrentMap<String, Configuration> configurationOverrides = new ConcurrentHashMap<String, Configuration>();
    private final GlobalComponentRegistry globalComponentRegistry;
    private final ReentrantPerEntryLockContainer cacheNameLockContainer;
    private final ReflectionCache reflectionCache = new ReflectionCache();

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        this.globalConfiguration = globalConfiguration == null ? new GlobalConfiguration() : globalConfiguration.clone();
        this.globalConfiguration.accept(new ConfigurationValidatingVisitor());
        this.defaultConfiguration = defaultConfiguration == null ? new Configuration() : defaultConfiguration.clone();
        this.defaultConfiguration.accept(new ConfigurationValidatingVisitor());
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache);
        this.cacheNameLockContainer = new ReentrantPerEntryLockContainer(this.defaultConfiguration.getConcurrencyLevel());
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationFile, InfinispanConfiguration.resolveSchemaPath(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.globalConfiguration = configuration.parseGlobalConfiguration();
            this.defaultConfiguration = configuration.parseDefaultConfiguration();
            for (Map.Entry<String, Configuration> entry : configuration.parseNamedConfigurations().entrySet()) {
                Configuration c = this.defaultConfiguration.clone();
                c.applyOverrides(entry.getValue());
                this.configurationOverrides.put(entry.getKey(), c);
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache);
            this.cacheNameLockContainer = new ReentrantPerEntryLockContainer(this.defaultConfiguration.getConcurrencyLevel());
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationStream, InfinispanConfiguration.findSchemaInputStream(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.globalConfiguration = configuration.parseGlobalConfiguration();
            this.defaultConfiguration = configuration.parseDefaultConfiguration();
            for (Map.Entry<String, Configuration> entry : configuration.parseNamedConfigurations().entrySet()) {
                Configuration c = this.defaultConfiguration.clone();
                c.applyOverrides(entry.getValue());
                this.configurationOverrides.put(entry.getKey(), c);
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache);
            this.cacheNameLockContainer = new ReentrantPerEntryLockContainer(this.defaultConfiguration.getConcurrencyLevel());
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String globalConfigurationFile, String defaultConfigurationFile, String namedCacheFile, boolean start) throws IOException {
        try {
            InfinispanConfiguration gconfiguration = InfinispanConfiguration.newInfinispanConfiguration(globalConfigurationFile, InfinispanConfiguration.resolveSchemaPath(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.globalConfiguration = gconfiguration.parseGlobalConfiguration();
            InfinispanConfiguration dconfiguration = InfinispanConfiguration.newInfinispanConfiguration(defaultConfigurationFile, InfinispanConfiguration.resolveSchemaPath(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.defaultConfiguration = dconfiguration.parseDefaultConfiguration();
            if (namedCacheFile != null) {
                InfinispanConfiguration NCconfiguration = InfinispanConfiguration.newInfinispanConfiguration(namedCacheFile, InfinispanConfiguration.resolveSchemaPath(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
                for (Map.Entry<String, Configuration> entry : NCconfiguration.parseNamedConfigurations().entrySet()) {
                    Configuration c = this.defaultConfiguration.clone();
                    c.applyOverrides(entry.getValue());
                    this.configurationOverrides.put(entry.getKey(), c);
                }
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache);
            this.cacheNameLockContainer = new ReentrantPerEntryLockContainer(this.defaultConfiguration.getConcurrencyLevel());
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.defineConfiguration(cacheName, configurationOverride, this.defaultConfiguration, true);
    }

    @Override
    public Configuration defineConfiguration(String cacheName, String templateName, Configuration configurationOverride) {
        if (templateName != null) {
            Configuration c = (Configuration)this.configurationOverrides.get(templateName);
            if (c != null) {
                return this.defineConfiguration(cacheName, configurationOverride, c, false);
            }
            return this.defineConfiguration(cacheName, configurationOverride);
        }
        return this.defineConfiguration(cacheName, configurationOverride);
    }

    private Configuration defineConfiguration(String cacheName, Configuration configOverride, Configuration defaultConfigIfNotPresent, boolean checkExisting) {
        Configuration existing;
        this.assertIsNotTerminated();
        if (cacheName == null || configOverride == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (cacheName.equals("___defaultcache")) {
            throw new IllegalArgumentException("Cache name cannot be used as it is a reserved, internal name");
        }
        if (checkExisting && (existing = (Configuration)this.configurationOverrides.get(cacheName)) != null) {
            existing.applyOverrides(configOverride);
            return existing.clone();
        }
        Configuration configuration = defaultConfigIfNotPresent.clone();
        configuration.applyOverrides(configOverride.clone());
        this.configurationOverrides.put(cacheName, configuration);
        return configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.getCache("___defaultcache");
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.assertIsNotTerminated();
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        CacheWrapper cw = (CacheWrapper)this.caches.get(cacheName);
        if (cw != null) {
            return cw.getCache();
        }
        boolean acquired = false;
        try {
            if (this.cacheNameLockContainer.acquireLock(cacheName, this.defaultConfiguration.getLockAcquisitionTimeout(), TimeUnit.MILLISECONDS) != null) {
                acquired = true;
                Cache cache = this.createCache(cacheName);
                return cache;
            }
            try {
                throw new CacheException("Unable to acquire lock on cache with name " + cacheName);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted while trying to get lock on cache with cache name " + cacheName, e);
            }
        }
        finally {
            if (acquired) {
                this.cacheNameLockContainer.releaseLock(cacheName);
            }
        }
    }

    @Override
    public String getClusterName() {
        return this.globalConfiguration.getClusterName();
    }

    @Override
    public List<Address> getMembers() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t == null ? null : t.getAddress();
    }

    @Override
    public Address getCoordinator() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t == null ? null : t.getCoordinator();
    }

    @Override
    public boolean isCoordinator() {
        if (this.globalComponentRegistry == null) {
            return false;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t != null && t.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="Cache name lock container keeps a lock per cache name which guards this method")
    private Cache createCache(String cacheName) {
        CacheWrapper existingCache = (CacheWrapper)this.caches.get(cacheName);
        if (existingCache != null) {
            return existingCache.getCache();
        }
        Configuration c = cacheName.equals("___defaultcache") || !this.configurationOverrides.containsKey(cacheName) ? this.defaultConfiguration.clone() : (Configuration)this.configurationOverrides.get(cacheName);
        c.setGlobalConfiguration(this.globalConfiguration);
        c.assertValid();
        Cache cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName, this.reflectionCache);
        CacheWrapper cw = new CacheWrapper(cache);
        try {
            existingCache = this.caches.putIfAbsent(cacheName, cw);
            if (existingCache != null) {
                throw new IllegalStateException("attempt to initialize the cache twice");
            }
            cache.start();
        }
        finally {
            cw.latch.countDown();
        }
        return cache;
    }

    @Override
    public void start() {
        this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).start();
    }

    @Override
    public void stop() {
        Lifecycle defaultCache = null;
        for (Map.Entry entry : this.caches.entrySet()) {
            if (((String)entry.getKey()).equals("___defaultcache")) {
                defaultCache = ((CacheWrapper)entry.getValue()).cache;
                continue;
            }
            Cache c = ((CacheWrapper)entry.getValue()).cache;
            if (c == null) continue;
            this.unregisterCacheMBean(c);
            c.stop();
        }
        if (defaultCache != null) {
            this.unregisterCacheMBean((Cache)defaultCache);
            defaultCache.stop();
        }
        this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).stop();
        this.globalComponentRegistry.stop();
        this.reflectionCache.stop();
    }

    private void unregisterCacheMBean(Cache cache) {
        if (cache.getStatus().allowInvocations() && cache.getConfiguration().isExposeJmxStatistics()) {
            cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class).unregisterCacheMBean();
        }
    }

    @Override
    public void addListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.globalComponentRegistry.getStatus();
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    @Override
    public Set<String> getCacheNames() {
        HashSet names = new HashSet(this.configurationOverrides.keySet());
        names.remove("___defaultcache");
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public boolean isRunning(String cacheName) {
        CacheWrapper w = (CacheWrapper)this.caches.get(cacheName);
        try {
            return w != null && w.latch.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean isDefaultRunning() {
        return this.isRunning("___defaultcache");
    }

    private void assertIsNotTerminated() {
        if (this.globalComponentRegistry.getStatus().isTerminated()) {
            throw new IllegalStateException("Cache container has been stopped and cannot be reused. Recreate the cache container.");
        }
    }

    @ManagedAttribute(description="The status of the cache manager instance.")
    @Metric(displayName="Cache manager status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheManagerStatus() {
        return this.getStatus().toString();
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.")
    @Metric(displayName="List of defined caches", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.getCacheNames()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The total number of defined caches, excluding the default cache.")
    @Metric(displayName="Number of caches defined", displayType=DisplayType.SUMMARY)
    public String getDefinedCacheCount() {
        return String.valueOf(this.configurationOverrides.keySet().size());
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.")
    @Metric(displayName="Number of caches created", displayType=DisplayType.SUMMARY)
    public String getCreatedCacheCount() {
        return String.valueOf(this.caches.keySet().size());
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.")
    @Metric(displayName="Number of running caches", displayType=DisplayType.SUMMARY)
    public String getRunningCacheCount() {
        int running = 0;
        for (CacheWrapper cachew : this.caches.values()) {
            Cache cache = cachew.cache;
            if (cache == null || cache.getStatus() != ComponentStatus.RUNNING) continue;
            ++running;
        }
        return String.valueOf(running);
    }

    @ManagedAttribute(description="Infinispan version.")
    @Metric(displayName="Infinispan version", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.printVersion();
    }

    @ManagedAttribute(description="The name of this cache manager")
    @Metric(displayName="Cache manager name", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getName() {
        return this.globalConfiguration.getCacheManagerName();
    }

    @ManagedOperation(description="Starts the default cache associated with this cache manager")
    @Operation(displayName="Starts the default cache")
    public void startCache() {
        this.getCache();
    }

    @ManagedOperation(description="Starts a named cache from this cache manager")
    @Operation(name="startCacheWithCacheName", displayName="Starts a cache with the given name")
    public void startCache(@Parameter(name="cacheName", description="Name of cache to start") String cacheName) {
        this.getCache(cacheName);
    }

    private String getLogicalAddressString() {
        return this.getAddress() == null ? "local" : this.getAddress().toString();
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }
}

