/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.binding;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DeserializerSupport
implements Deserializer {
    private static final Logger log = Logger.getLogger(DeserializerSupport.class);
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");

    public Object deserialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException {
        QName xmlName = soapElement.getElementQName();
        QName xmlType = soapElement.getXmlType();
        Source source = soapElement.getXMLFragment().getSource();
        return this.deserialize(xmlName, xmlType, source, serContext);
    }

    public abstract Object deserialize(QName var1, QName var2, Source var3, SerializationContext var4) throws BindingException;

    protected String sourceToString(Source source) {
        String xmlFragment = null;
        if (!(source instanceof DOMSource)) {
            throw new UnsupportedOperationException();
        }
        Node node = ((DOMSource)source).getNode();
        xmlFragment = DOMWriter.printNode((Node)node, (boolean)false);
        return xmlFragment;
    }

    protected Element sourceToElement(Source source) {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                return (Element)node;
            }
            throw new UnsupportedOperationException("Only element nodes are supported");
        }
        throw new UnsupportedOperationException("Only DOMSource is supported");
    }

    protected String unwrapValueStr(Element xmlFragment) {
        String content = DOMUtils.getTextContent((Node)xmlFragment);
        if (content == null) {
            return this.isNil(xmlFragment) ? null : "";
        }
        return content;
    }

    private boolean isNil(Element element) {
        String nilValue = DOMUtils.getAttributeValue((Element)element, (QName)XSI_NIL);
        return "1".equals(nilValue) || "true".equals(nilValue);
    }

    public String getMechanismType() {
        throw new NotImplementedException();
    }
}

