/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.impl.wireformat.MessagePacket;
import org.hornetq.spi.core.protocol.RemotingConnection;

public class SessionReceiveMessage
extends MessagePacket {
    private static final Logger log = Logger.getLogger(SessionReceiveMessage.class);
    private long consumerID;
    private int deliveryCount;

    public SessionReceiveMessage(long consumerID, MessageInternal message, int deliveryCount) {
        super((byte)75, message);
        this.consumerID = consumerID;
        this.deliveryCount = deliveryCount;
    }

    public SessionReceiveMessage() {
        super((byte)75, new ClientMessageImpl());
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public HornetQBuffer encode(RemotingConnection connection) {
        HornetQBuffer buffer = this.message.getEncodedBuffer();
        if (buffer.writerIndex() != this.message.getEndOfMessagePosition()) {
            throw new IllegalStateException("Wrong encode position");
        }
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
        this.size = buffer.writerIndex();
        int len = this.size - 4;
        buffer.setInt(0, len);
        buffer.setByte(4, this.type);
        buffer.setLong(5, this.channelID);
        buffer.setIndex(0, this.size);
        return buffer;
    }

    @Override
    public void decode(HornetQBuffer buffer) {
        this.channelID = buffer.readLong();
        this.message.decodeFromBuffer(buffer);
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
        this.size = buffer.readerIndex();
        buffer.setIndex(17, this.message.getEndOfBodyPosition());
    }
}

